/*
   This program just reads lines from standard input (stdin)
   and echos them to standard output (stdout).

   If standard input is the console keyboard,
   use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).

   Try running this program from a command line using
   command line I/O redirections. For example
   C:\> java Echo > test.txt
   or
   C:\> java Echo < Echo.java
   or
   C:\> java Echo < Echo.java > test2.txt
*/
import java.util.Scanner;

public class Echo
{
   public static void main(String[] args)
   {
      // Create a Scanner object to make it easier to use System.in
      Scanner scanner = new Scanner( System.in );

      // Echo every line of input from stdin to stdout.
      while ( scanner.hasNextLine() )
      {
         String oneLine = scanner.nextLine();
         System.out.println( oneLine );
      }
   }
}